<?PHP 
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$this->load->helper('form');
?>
				<h1>Logins</h1>
				<div class="column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/requests">Requests</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/events">Events</a></li>
							<li class="reports-tab ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/reports/logins">Logins</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/mail">Mail</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/tickets">Tickets</a></li>
						</ul>
					<div class="tab-content">
						<p>This table lists the logins.</p>
						<?PHP echo form_open('/reports/logins',array('id'=>'reports_form','onsubmit'=>"javascript:submitPaginationForm('', this.value, ".$form_data['items_per_page'].", '');")); ?>
							<table class="form">
								<tr class="form_row">
									<td>Success:</td>
									<td>
										<select class="fill_row" id="successful" name="successful" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<option value="1" <?php if(isset($form_data['successful']) && '1'==$form_data['successful']){echo "selected";}?>>TRUE</option>
											<option value="0" <?php if(isset($form_data['successful']) && '0'==$form_data['successful']){echo "selected";}?>>FALSE</option>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td>ID:</td>
									<td>
										<p class="hidden_context">Help Text for ID: Table ID of the login request</p>
										<input class="ttFocus" title="Table ID of the login request" id="id" name="id" type="text" value="<?php if(isset($form_data['id'])) { echo $form_data['id']; } ?>" onkeydown="if(event.keyCode == 13){$('#id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for ID</label>
										<select id="id_type" name="id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['id_type']) && $key == $form_data['id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Username:</td>
									<td>
										<p class="hidden_context">Help Text for Username: Username of the user that logged in</p>
										<input class="ttFocus" title="Username of the user that logged in" id="username" name="username" type="text" value="<?php if(isset($form_data['username'])) { echo $form_data['username']; } ?>" onkeydown="if(event.keyCode == 13){$('#username').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for Username</label>
										<select id="username_type" name="username_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['username_type']) && $key==$form_data['username_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>Session ID:</td>
									<td>
										<p class="hidden_context">Help Text for Session ID: The Session ID is a unique identified assigned by the server for the duration of the users visit</p>
										<input class="ttFocus" title="The Session ID is a unique identified assigned by the server for the duration of the users visit" id="session_id" name="session_id" type="text" value="<?php if(isset($form_data['session_id'])) { echo $form_data['session_id']; } ?>" onkeydown="if(event.keyCode == 13){$('#session_id').onfocus = function(){this.form.submit();return false;}}"></input>								
									</td>
									<td>
										<label class="hidden_context">Compare options for Session ID</label>
										<select id="session_id_type" name="session_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['session_id_type']) && $key == $form_data['session_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>IP Address:</td>
									<td>
										<p class="hidden_context">Help Text for IP Address: IP Address of user</p>
										<input class="ttFocus" title="IP Address of user" id="ip_address" name="ip_address" type="text" value="<?php if(isset($form_data['ip_address'])) { echo $form_data['ip_address']; } ?>" onkeydown="if(event.keyCode == 13){$('#ip_address').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for IP Address</label>
										<select id="ip_address_type" name="ip_address_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['ip_address_type']) && $key == $form_data['ip_address_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>Message:</td>
									<td>
										<p class="hidden_context">Help Text for Message: Login message (Success/Unregistered/Error)</p>
										<input class="ttFocus" title="Login message (Success/Unregistered/Error)" id="message" name="message" type="text" value="<?php if(isset($form_data['message'])) { echo $form_data['message']; } ?>" onkeydown="if(event.keyCode == 13){$('#message').onfocus = function(){this.form.submit();return false;}}"></input>								
									</td>
									<td>
										<label class="hidden_context">Compare options for  Message</label>
										<select id="message_type" name="message_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['message_type']) && $key == $form_data['message_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Org ID:</td>
									<td>
										<p class="hidden_context">Help Text for Org ID: Organization ID for user</p>
										<input class="ttFocus" title="Organization ID for user" id="org_id" name="org_id" type="text" value="<?php if(isset($form_data['org_id'])) { echo $form_data['org_id']; } ?>" onkeydown="if(event.keyCode == 13){$('#org_id').onfocus = function(){this.form.submit();return false;}}"></input>								
									</td>
									<td>
										<label class="hidden_context">Compare options for Org ID</label>
										<select id="org_id_type" name="org_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['org_id_type']) && $key == $form_data['org_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>Start Date:</td>
									<td><input type="text" id="start_date" name="start_date" class="date" value="<?php if(isset($form_data['start_date'])) { echo $form_data['start_date']; } ?>"onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}"/></td>
									<td>&nbsp;</td>
									<td>End Date:</td>
									<td><input type="text" id="end_date" name="end_date" class="date" value="<?php if(isset($form_data['end_date'])) { echo $form_data['end_date']; } ?>"onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}"/></td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt"});</script>
							</table>
							<?PHP
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							<?php if(sizeof($event_list) != 0) { ?>
								<div class="pagination">
									<?php echo $form_data['pages']->display_result_num();?>
									<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
									<?php echo $form_data['pages']->display_items_per_page();?>
									<div style="float:right; position:relative">
										<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" onclick ="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');" />
										<label class="hidden_context">Page Selector</label>
										<select id="page_select" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '');" >
											<?php for($count = 1;$count <= $form_data['num_pages'];$count++){ ?>
											<option value="<?php echo $count;?>" <?php if($count == $form_data['cur_page']){echo "selected";}?>><?php echo $count;?></option>
											<?php  } ?>
										</select>
										<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
									</div>
								</div>
							<?php } ?>
						<?PHP echo form_close(); ?>
						<?PHP echo form_open('/reports/logins',array('id'=>'clear_form')); echo form_close(); ?>
						<?php if(sizeof($event_list) == 0) { ?>
							<div class="message">There are currently no logins.</div>
						<?php }else{ ?>
							<table class="display">	
								<tr class="report_row">
									<th width="5%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','id');$('#change').attr('value','true');$('#reports_form').submit();">ID<?php  if(isset($form_data['order'])&&$form_data['order'] == 'id'){echo $image;} ?></a></th>
									<th width="10%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','user_id');$('#change').attr('value','true');$('#reports_form').submit();">Username<?php  if(isset($form_data['order'])&&$form_data['order'] == 'user_id'){ echo $image; } ?></a></th>
									<th width="18%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','session_id');$('#change').attr('value','true');$('#reports_form').submit();">Session ID<?php  if(isset($form_data['order'])&&$form_data['order'] == 'session_id'){ echo $image; } ?></a></th>
									<th width="10%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','ip_address');$('#change').attr('value','true');$('#reports_form').submit();">IP Address<?php  if(isset($form_data['order'])&&$form_data['order'] == 'ip_address'){ echo $image; } ?></a></th>
									<th width="11%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','login_time');$('#change').attr('value','true');$('#reports_form').submit();">Date (<?php echo $timezone_abbr; ?>)<?php  if(isset($form_data['order'])&&$form_data['order'] == 'login_time'){echo $image; } ?></a></th>
									<th width="9%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','error_msg');$('#change').attr('value','true');$('#reports_form').submit();">Message<?php  if(isset($form_data['order'])&&$form_data['order'] == 'error_msg'){echo $image; } ?></a></th>
									<th width="9%"><a href='#' style="color:#FFFFFF;"onclick="$('#order').attr('value','org_id');$('#change').attr('value','true');$('#reports_form').submit();">Org ID<?php  if(isset($form_data['order'])&&$form_data['order'] == 'org_id'){echo $image; } ?></a></th>
									<th width="7%" class="displaylast"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','success');$('#change').attr('value','true');$('#reports_form').submit();">Success<?php  if(isset($form_data['order'])&&$form_data['order'] == 'success'){ echo $image; } ?></a></th>
								</tr>
						
								<?php foreach($event_list as $request){ ?>
									<tr class="report_row">
										<td class="break-word"><?php echo $request->id; ?></td>
										<td class="break-word"><?php echo $request->user_id; ?></td>
										<td class="break-word"><?php echo $request->session_id; ?></td>
										<td class="break-word" ><?php echo $request->ip_address; ?></td>
										<td class="break-word" ><?php echo $request->login_time; ?></td>
										<td class="break-word " ><?php echo $request->error_msg; ?></td>
										<td class="break-word" ><?php echo $request->org_id; ?></td>
										<td class="break-word " ><?php echo $request->success; ?></td>
									</tr>
								<?php  } ?>
							</table>
							
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page();?>
								<div style="float:right; position:relative">
									<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" onclick ="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');" />
									<label class="hidden_context">Page Selector</label>
									<select id="page_select" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '');" >
										<?php for($count = 1;$count <= $form_data['num_pages'];$count++){ ?>
										<option value="<?php echo $count;?>" <?php if($count == $form_data['cur_page']){echo "selected";}?>><?php echo $count;?></option>
										<?php  } ?>
									</select>
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
							
						<?php } ?>
						</div>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>